#!/bin/bash

# VERSION 	3.0
# DATE		2020/12/31
# script for installing xavier.
set -e

source bash_functions.sh

#add extra repository
extra_repository()
{
	echo_title "add extra repository" 
	sudo add-apt-repository universe
	sudo add-apt-repository multiverse
	#sudo apt-add-repository ppa:/relan/exfat
	sudo apt-get update
}

# Common
common()
{
	echo_title "common"
	RET=$(PkgInstall nano)
	RET=$(PkgInstall ssh)
	RET=$(PkgInstall samba)
	RET=$(PkgInstall cifs-utils)
	RET=$(PkgInstall dos2unix)
	RET=$(PkgInstall exfat-fuse)
}

#build Yuan's app
yuan_app()
{
	echo_title "Install package for build Yuan's app"
	#RET=$(PkgInstall apt-utils)
	RET=$(PkgInstall libxvmc-dev)
	#RET=$(PkgInstall libx264-*)
	#RET=$(PkgInstall x264)
}

# media
media()
{
	echo_title "Media packages"
	RET=$(PkgInstall v4l-utils)
	RET=$(PkgInstall qv4l2)
	#RET=$(PkgInstall vlc)
	#RET=$(PkgInstall ffmpeg)
	#RET=$(PkgInstall vooya)
}

# gstreamer
gstreamer_common()
{
	echo_title "Gstreamer"
	#sudo add-apt-repository universe
	#sudo add-apt-repository multiverse
	#sudo apt-get update
	RET=$(PkgInstall gstreamer1.0-tools)
	RET=$(PkgInstall gstreamer1.0-alsa)
	RET=$(PkgInstall gstreamer1.0-plugins-base)
	RET=$(PkgInstall gstreamer1.0-plugins-good)
	RET=$(PkgInstall gstreamer1.0-plugins-bad)
	RET=$(PkgInstall gstreamer1.0-plugins-ugly)
	RET=$(PkgInstall gstreamer1.0-libav)
	RET=$(PkgInstall libgstreamer1.0-dev)
}

# Dev packages of gstreamer
gstreamer_dev()
{
	echo_title "Dev for Gstreamer"
	#sudo apt-get install -y 
	RET=$(PkgInstall libgstreamer-plugins-base1.0-dev)
	RET=$(PkgInstall libgstreamer-plugins-good1.0-dev)
	RET=$(PkgInstall libgstreamer-plugins-good1.0-0)
	RET=$(PkgInstall libgstreamer-plugins-bad1.0-dev)
	RET=$(PkgInstall libgstreamer-plugins-bad1.0-0)
	RET=$(PkgInstall libgstreamer0.10-dev)
	RET=$(PkgInstall libgdk-pixbuf2.0-dev)
	RET=$(PkgInstall libgstreamermm-1.0-dev)
	RET=$(PkgInstall libxml2-dev)
	RET=$(PkgInstall libgtk2.0-dev)
	RET=$(PkgInstall libgstrtspserver-1.0)
	RET=$(PkgInstall libgstreamer1.0-dev)
	RET=$(PkgInstall libgstreamer-plugins-base1.0-0)
	RET=$(PkgInstall libgstreamer-plugins-base0.10-dev)
	RET=$(PkgInstall )
}

# programming
programming()
{
	echo_title "Programming"
	RET=$(PkgInstall git)
	RET=$(PkgInstall git-core)
	#RET=$(PkgInstall svn)
	#RET=$(PkgInstall cvs)
	#RET=$(PkgInstall busybox)
	#RET=$(PkgInstall bless)
}

# to build kernel on tx2
build_on_tx2()
{
	echo_title "Package for build on Tx2"
	RET=$(PkgInstall gcc-arm-linux-gnueabihf)
	RET=$(PkgInstall gcc-5-plugin-dev-arm-linux-gnueabihf)
	RET=$(PkgInstall fakeroot)
	RET=$(PkgInstall build-essential)
	RET=$(PkgInstall kernel-package)
	RET=$(PkgInstall libncurses5)
	RET=$(PkgInstall libncurses5-dev)
	RET=$(PkgInstall ncurses-dev)
	RET=$(PkgInstall xz-utils)
}

network()
{
	echo_title "Network packages"
	RET=$(PkgInstall telnet)
	RET=$(PkgInstall telnetd)
	RET=$(PkgInstall xinetd)
}

corss_compiler()
{
	echo_title "Package for cross compiler"
	RET=$(PkgInstall libx11-dev)
}

vnc()
{
	echo_title "Package for VNC"
	RET=$(PkgInstall xrdp vnc4server xbase-clients)
	RET=$(PkgInstall dconf-editor)
}

Bonjour()
{
	echo_title "Package for Bonjour"
	RET=$(PkgInstall avahi-daemon) 
	RET=$(PkgInstall avahi-discover) 
	RET=$(PkgInstall avahi-utils)
}

main()
{
	extra_repository;
	#common;
	yuan_app;
	media;
	#gstreamer_common;
	#gstreamer_dev;
	#programming;
	#build_on_tx2;
	#network;
	#corss_compiler;
	#vnc;
	#Bonjour;
}

main $@
